# ISISTEM

Repositório de produção do ISISTEM para montar versões

#### Segue abaixo o tutorial para lançamento do versão

#### Aqui estão os passos mas importantes que com o passar do tempo podem sofre alteração

#### Nada do que está escrito é uma regra

## Lançamento de sistema

#### Bloco - 00: Preparando o ambiente para atualização

- Dentro da pasta recursos_update
- O arquivo numero da versao_anterio.php (Ex: 7.3.php)
- Mude o nome para a nova versão (Ex: 7.4.php) e acrescente as novidades e correções
- No arquivo atualizar.php mudar a variável $versao_nova para a versão atual e adicione os novos SQL
- Os novos SQL se encontra no arquivo nova_versao.txt (Ex: 7.4.txt)
- Atualizar as novidades e correções do arquivo atualizacoes.site.html
- Remova o active da versão anterior e adicione o active na nova versão

#### Bloco - 01: Preparando as pastas

- Criar nova pasta com o nome da versão, files_nome_da_versão (Ex: files_7.4)
- Colocar dentro da pasta que foi criada os arquivos arq.json e atualizar.php, que fica dentro de recursos_update
- Criar um pasta chamada root
- Dentro da pasta root cole todo o isistem exceto as pasta .git e .vscode
- Remover config.php que fica dentro da pasta inc
- Dentro da pasta recurso_update vamos deixar apenas os arquivos .sh
- Remover arquivos .txt
- Remover arquivos (teste.php, 1.php, etc… )

#### Bloco - 02: Cryptografando o arquivo

- Abrir o ionCube e crie um novo projeto
- procure a pasta root e selecione ela
- na pasta de saida coloque o nome root_cript
- No local de saida selecione a pasta file_nome_da_versão
- Selecione a versão PHP 8.1
- Iniciar a cryptografia

#### Bloco - 03: Montando o arquivo.zip

- Abra a pasta root_cript
- Selecione tudo exceto a pasta \_instalar e compacte com nome root.zip (E obrigatório ser esse nome)
- Mova o arquivo zipado para a pasta file.nova_vesao (Ex: files_7.4)
- Selecione o arquive root.zip, atualizar.php e arq.json e transforme em um arquivo zipado com o nome numero_da_vesao.zip (Ex: 7.4.zip)

#### Bloco - 04: Subindo arquivos para o servidor

- No gerenciador de arquivos acesse o diretório /public_html/update3/ e faça o upload do arquivo numero_da_versao.zip
- Acesse o diretório public_html/update3/paginas_atualizacao/ e faça upload do arquivo nova_vesao.php (que contém as novidades e correções)
- Acesse o diretório /public_html/update3/ e abra o arquivo update.php
- Procure pelo "elseif" da ultima versão e escreva a verificação para teste como no exemplo abaixo 👇👇👇

Exemplo:

`sh
    elseif ($versao == "60") {
        include("paginas_atualizacao/[nova_versao_aqui].php");
        echo "##";
        echo " https://isistem.com.br/update3/[nova_versao_aqui].zip";
    }
`

<br>
ATENÇÃO: Existe um if e elseif no topo do código ou seja coloque dentro a verificação acima tonto no if quanto no else;
ATENÇÃO: Essa verificação ($versao == "60") e apenas para teste, quando for libera(Lá ele) altere o 60 para o numero da nova versão (Ex: 7.4)

#### Bloco - 05: Mudança no banco de dados

- Acesse o banco isistem_controle 
- Na tabela versao coloqua versão 60 com o status 0


LEGENDA: 

status = 0, versão liberada para atualizar
status = 1, versão bloqueada para atualização

#### Bloco - 06: Testando

- No servidor do demo.isistem.com.br depois de testar remova os arquivo abaixo 
    - Clientes.edita.php
    - Configuracoes.Operadores.php
    - Utilitarios.Atualizando.php
- No momento dos testes tente testar todas as funcionalidades principalmente financeiro, ticket e clientes, verifique também as novas funcionalidades e aonde foi feitas as correções

#### Bloco - 07: Liberando para os clientes (Lá ele Renato)

- Acesse o diretório /public_html/update3/ e abra o arquivo update.php e na verificação altere a versão 60 para a versão_anterio
- Acesse o banco de dados "isistem_controle" na tabela versao vai inserir na coluna versao coloque a nova versao e na coluna data_de_mudanca coloque a data e hora que está lançando a nova versão e na coluna status coloque 1
- mude o status da versão anterior para 0 

ATENÇÃO: Quando mudar o status da versão anterior para 0, a nova versão estará liberada

#### Bloco - 08: Atualizando site

- Acesse o diretório public_html/atualizacoes/index.html
- Na pasta Recurso_Updata acesse o arquivo atualizar.site.html, copie todo o conteúdo desse arquivo e cole no diretório acima 


# INSTALADOR 

#### Bloco - 00: Organizando os Arquivos

- Abra a pasta _instalar
- Abra o arquivo instalar.php e procure a variável $sistema_versao e no valor da variável coloque o número da versão do instalador
- Copie todo conteúdo do arquivo instalar.php e cole no instalarinnob.php
- Abra o sql.txt e cole todos os sql da nova versão
- Depois de ter colocado todos sql da nova versão copie todo conteúdo do arquivo sql.txt e cole no sqlinnoDB.txt

#### Bloco 01: Montando o arquivo zip

- Selecione todo o isistem, menos os arquivos txt e arquivos de testes
- transfome em arquivo zip com o nome "instalar-numero da versão" Ex: instalar-8.0 (OBS: Esse nome e obrigatório)

#### Bloco 02: Subindo para o servidor

- Entre no servidor do isistem.com.br
- Abra o gerenciador de arquivos
- Abra a pasta ZIPS que fica localizada nesse caminho public_html/update3
- Faça upload do instalador zipado
- Abra a pasta download que fica localizada nesse caminho public_html/download
- Abra o arquivo index.php
- Mude todos html onde fala sobre a versão para o numero da nova versão (OBS: Não se esqueça de arrumar o link do instalador)





