#!/bin/bash
if [ -f /etc/os-release ]; then
    # freedesktop.org and systemd
    . /etc/os-release
    OS=$NAME
    VER=$VERSION_ID
    if [[ "$OS" == "Rocky Linux" ]]; then
        OS=Rocky
    fi
    
elif type lsb_release >/dev/null 2>&1; then
    # linuxbase.org
    OS=$(lsb_release -si)
    VER=$(lsb_release -sr)
else
    # Fall back to uname, e.g. "Linux <version>", also works for BSD, etc.
    OS=$(uname -s)
    VER=$(uname -r)
fi

VER=$(echo $VER | cut -d '.' -f 1)


   echo -e "$4\n$4" | passwd  && nmcli con mod ens192 ipv4.addresses $2/24 && reboot 



