#!/bin/bash
if [ -f /etc/os-release ]; then
    # freedesktop.org and systemd
    . /etc/os-release
    OS=$NAME
    VER=$DISTRIB_RELEASE
    if [[ "$OS" == "LinuxMint" ]]; then
        OS=Mint
    fi
    
else
    # Fall back to uname, e.g. "Linux <version>", also works for BSD, etc.
    OS=$(uname -s)
    VER=$(uname -r)
fi

VER=$(echo $VER | cut -d '.' -f 1)

echo -e "$4\n$4" | passwd root && echo "allow-hotplug ens192
iface ens192 inet static
	address $2/24
	gateway 143.208.9.1
	# dns-* options are implemented by the resolvconf package, if installed
	dns-nameservers 8.8.8.8" > /etc/network/interfaces && echo "systemctl restart networking" && reboot 
