// Função para inserir/remover um tipo de domínio
function tipo_dominio(acao, tipo) {

  if (tipo != "" && tipo != "null") {

    document.getElementById("div_status").innerHTML = "<img src='img/spinner.gif' />";

    var http = new Ajax();
    http.open("GET", "inc/funcoes.php?acao=" + acao + "&tipo=" + tipo, true);
    http.onreadystatechange = function () {

      if (http.readyState == 4) {
        resultado = http.responseText;

        partes = resultado.split("&");

        if (partes['0'] == "ok") {
          if (partes['1'] == "inserir_tipo_dominio") {
            var campo = document.getElementById("tipo");
            var nova_opcao = document.getElementById("nova_opcao").value;
            linha = document.createElement("OPTION");
            campo.appendChild(linha);
            linha.value = nova_opcao;
            linha.text = nova_opcao;
            linha.selected = 1;
            document.getElementById("div_status").innerHTML = "";
            alert("O tipo de domínio " + nova_opcao + " foi adicionado com sucesso! Escolha-o na lista ao lado.");
          } else {
            var tipo = document.getElementById("tipo");
            tipo.remove(tipo.selectedIndex);

            document.getElementById("div_status").innerHTML = "";
            alert("Tipo de domínio removido com sucesso!");
          }
        } else if (partes['0'] == "bloqueado") {
          document.getElementById("div_status").innerHTML = "";
          alert("Este tipo de domínio não pode ser removido pois faz parte do sistema!");
        } else {
          alert("Não foi possível executar esta ação! Tente novamente ou entre em contato diretamente com o suporte.");
        }
      }
    }
    http.send(null);
    delete http;
  }
}

// Função para inserir/remover um grupo de plano
function grupo_plano(opcao, grupo) {

  if (opcao == 'adicionar') {
    var grupo = prompt('Informe o novo grupo que deseja cadastrar para este plano:', ' ');
  }

  if (grupo != "" && grupo != "null") {

    $("#drop_grupos").addClass("loading");
    var http = new Ajax();
    http.open("GET", "inc/funcoes.php?acao=grupo_plano&opcao=" + opcao + "&grupo=" + grupo, true);
    http.onreadystatechange = function () {

      if (http.readyState == 4) {

        resultado = http.responseText;

        partes = resultado.split("|");

        if (partes[0] == "ok") {

          if (partes[1] == "adicionar") {


            var novo_grupo = partes[2];
            var menu_drop = $("#menu_drop_grupos");
            menu_drop.append("<div class='item' data-value='" + novo_grupo + "' id='grp-" + novo_grupo + "'>" + novo_grupo + "</div>");
            $("#drop_grupos").dropdown('set value', novo_grupo);
            $("#drop_grupos").removeClass("loading");
            alert("Grupo " + novo_grupo + " foi adicionado com sucesso! Atualize a Página e Escolha-o na lista acima.");
          } else {
            var novo_grupo = partes[2];
            $("#grp-" + novo_grupo).remove();
            $("#drop_grupos").dropdown("clear");
            $("#drop_grupos").removeClass("loading");
            alert("Grupo " + partes[2] + " removido com sucesso!");
          }

        } else {
          alert("Não foi possível executar esta ação! Tente novamente ou entre em contato diretamente com o suporte.");
        }
      }
    }
    http.send(null);
    delete http;
  }
}

// Função para testar a integração de um servidor com o cPanel/WHM
function testar_integracao_whm() {

  var usuario = document.getElementById("usuario_whm").value;
  var host = document.getElementById("ip").value;
  var accesshash = document.getElementById("accesshash").value;

  if (host != "" && usuario != "" && accesshash != "") {

    var http = new Ajax();
    http.open("POST", "inc/funcoes.php", true);
    http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    http.onreadystatechange = function () {

      if (http.readyState == 4) {

        resultado = http.responseText;

        partes = resultado.split("|");

        if (resultado) {
          alert("Integração configurada com sucesso!\n \nVersão do WHM: " + partes[0] + "\nHostname: " + partes[1] + "");
        } else {
          alert("Não foi possível conectar-se ao WHM.\nVerifique se digitou as informações corretamente e tente novamente!");
        }
      }
    }
    http.send("acao=testar_integracao_whm&host=" + host + "&usuario=" + usuario + "&accesshash=" + accesshash);
    delete http;
  } else {
    alert("Preencha todos os campos para integração(IP, Usuário WHM e Remote Access Key)");
  }
}
// Função para recuperar senha do operador/cliente
function recuperar_senha_envia(usuario, tipo) {

  if (tipo == "cliente") {
    var url = "../inc/funcoes.php?acao=recuperar_senha&usuario=" + usuario + "&tipo=cliente";
    var icone = "<img src='../img/icone/icon_warning_sm.gif' />";
    var icone2 = "<div style='text-align:center; padding: 10px;'><img src='../img/spinner.gif' /></div>";
  } else if (tipo == "assinatura") {
    var url = "../inc/funcoes.php?acao=recuperar_senha&usuario=" + usuario + "&tipo=cliente";
    var icone = "<img src='../img/icone/icon_warning_sm.gif' />";
    var icone2 = "<div style='text-align:center; padding: 10px;'><img src='../img/spinner.gif' /></div>";
  } else if (tipo == "sub") {
    var url = "../inc/funcoes.php?acao=recuperar_senha&usuario=" + usuario + "&tipo=sub";
    var icone = "<img src='../img/icone/icon_warning_sm.gif' />";
    var icone2 = "<div style='text-align:center; padding: 10px;'><img src='../img/spinner.gif' /></div>";
  } else {
    var url = "inc/funcoes.php?acao=recuperar_senha&usuario=" + usuario + "&tipo=operador";
    var icone = "<img src='img/icone/icon_warning_sm.gif' />";
    var icone2 = "<div style='text-align:center; padding: 10px;'><img src='../img/spinner.gif' /></div>";
  }

  if (usuario == "" && tipo == "cliente") {
    alert("Por favor digite seu E-mail Principal no campo acima.");
    document.getElementById('cliente_email').focus();
  }
  else if (usuario == "" && tipo == "assinatura") {
    alert("Por favor digite seu E-mail Principal no campo acima.");
    document.getElementById('cliente_email').focus();
  }
  else if (usuario == "" && tipo != "cliente") {
    alert("Por favor digite seu usuário no campo acima.");
    document.getElementById('login_sistema').focus();
  }
  else {
    document.getElementById("div_senha").innerHTML = icone2 + "<p> Aguarde...</p>";

    var http = new Ajax();
    http.open("GET", url, true);
    http.onreadystatechange = function () {

      if (http.readyState == 4) {
        resultado = http.responseText;
        if (resultado != "ok") {
          document.getElementById("div_senha").innerHTML = icone + " <p>Erro ao recuperar senha.</p>";
          alert("Não foi possível recuperar sua senha! Por favor tente novamente ou entre em contato diretamente com o suporte.");
        }
        else if (resultado == "erro_usuario") {
          document.getElementById("div_senha").innerHTML = icone + " <p>Usuário não cadastrado no sistema.</p>";
          alert("Usuário não cadastrado no sistema! Por favor tente novamente ou entre em contato diretamente com o suporte.");
        }
        else {
          document.getElementById("div_senha").innerHTML = "";
          alert("Sua senha foi enviada para seu e-mail no cadastro.");
        }
      }

    }
    http.send(null);
    delete http;
  }
}

// Função para atualizar informações do bloco de notas do operador
function apaga_status() {
  document.getElementById("div_resultado").innerHTML = "";
}
function bloco_notas_atualiza() {

  var notas = document.getElementById("notas").value;

  if (notas == '') {
    alert("Por favor digite algo no bloco de notas!");
  } else {
    document.getElementById("div_resultado").innerHTML = "<img src='img/spinner.gif' align='absmiddle' /> Atualizando bloco de notas...";

    var http = new Ajax();
    http.open("POST", "inc/funcoes.php", true);
    http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    http.onreadystatechange = function () {

      if (http.readyState == 4) {
        resultado = http.responseText;

        partes = resultado.split("&");

        if (partes['0'] == "ok") {
          document.getElementById("div_resultado").innerHTML = "Bloco de notas atualizado com sucesso!";
          document.getElementById("data").innerHTML = partes['1'];
          alert("Bloco de notas atualizado com sucesso!");
          window.setTimeout("apaga_status()", 3000);
        } else {
          document.getElementById("div_resultado").innerHTML = "<img src='img/icones/atencao2.png' align='absmiddle' /> Erro ao atualizar bloco de notas.";
          alert("Não foi possível atualizar o bloco de notas! Por favor tente novamente ou entre em contato diretamente com o suporte.");
          document.getElementById("data").innerHTML = "Erro!";
          document.getElementById("notas").value = "Erro!";
        }
      }

    }
    http.send("acao=atualizar_bloco_notas&notas=" + notas);
    delete http;
  }
}
// Função para editar perfil do operador
function perfil_edita() {

  var nome = document.getElementById("nome").value;
  var email = document.getElementById("email").value;
  var senha = document.getElementById("senha_cadastro").value;

  if (nome == '' || email == '' || senha == '') {
    alert("Todos os campos são obrigotórios");
  } else {
    document.getElementById("div_resultado").innerHTML = "<img src='img/spinner.gif' align='absmiddle' /> Atualizando perfil...";

    var http = new Ajax();
    http.open("POST", "inc/funcoes.php", true);
    http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    http.onreadystatechange = function () {

      if (http.readyState == 4) {
        resultado = http.responseText;

        if (resultado == "ok") {
          document.getElementById("div_resultado").innerHTML = "Perfil alterado com sucesso!";
          alert("Perfil alterado com sucesso!");

          window.setTimeout("apaga_status()", 3000);

        } else {
          document.getElementById("div_resultado").innerHTML = resultado;
          alert("Não foi possível atualizar seu perfil! Por favor tente novamente ou entre em contato diretamente com o suporte.");
        }
      }

    }
    http.send("acao=alterar_perfil&nome=" + nome + "&email=" + email + "&senha=" + senha);
    delete http;
  }
}

// Função para alterar senha do dominio no servidor
function alterar_senha(senha, dominio) {

  if (senha == "") {
    alert("Por favor digite uma senha!");
  } else {
    document.getElementById("div_senha").innerHTML = "<img src='../img/spinner.gif' /> Aguarde...";

    var http = new Ajax();
    http.open("GET", "../inc/funcoes.php?acao=alterar_senha&senha=" + senha + "&dominio=" + dominio, true);
    http.onreadystatechange = function () {

      if (http.readyState == 4) {
        resultado = http.responseText;
        if (resultado == "erro") {
          alert("Não foi possível alterar sua senha! Por favor tente novamente ou entre em contato com o suporte.");
          document.getElementById("div_senha").innerHTML = '<input name="senha_cpanel" type="text" class="input" id="senha_cpanel" size="30" onblur="alterar_senha(this.value)" /> Digite no mínimo 8 caracteres.';
        } else {
          alert("Sua senha foi alterada com sucesso no cPanel/WHM." + resultado);
          document.getElementById("div_senha").innerHTML = resultado;
        }
      }

    }
    http.send(null);
    delete http;
  }
}

// Função para alterar senha do cliente na central do cliente
function alterar_senha_cliente(senha, codigo_cliente) {

  if (senha == "") {
    alert("Por favor digite uma senha!");
  } else {
    document.getElementById("div_senha").innerHTML = "<img src='../img/spinner.gif' /> Aguarde...";

    var http = new Ajax();
    http.open("GET", "../inc/funcoes.php?acao=alterar_senha_cliente&senha=" + senha + "&codigo_cliente=" + codigo_cliente, true);
    http.onreadystatechange = function () {

      if (http.readyState == 4) {
        resultado = http.responseText;
        if (resultado) {
          alert("Sua senha foi alterada com sucesso na Central do Cliente.");
          document.getElementById("div_senha").innerHTML = resultado;
        } else {
          alert("Não foi possível alterar sua senha! Por favor tente novamente ou entre em contato com o suporte.");
          document.getElementById("div_senha").innerHTML = '<input name="cliente_senha" type="text" class="input" id="cliente_senha" size="30" onblur="alterar_senha_cliente(this.value,' + codigo_cliente + ')" /> Digite no mínimo 8 caracteres.';

        }
      }

    }
    http.send(null);
    delete http;
  }
}

// Função para enviar a confirmação de pagamento pelo cliente pela central do cliente
function confirmar_pagamento_central_cliente() {

  var codigo_fatura = document.getElementById("codigo_fatura").value;
  var data_pagamento = document.getElementById("data_pagamento").value;
  var valor_pago = document.getElementById("valor_pago").value;
  var info = document.getElementById("info").value;

  if (!codigo_fatura || !data_pagamento || !valor_pago || !info) {
    alert("Todos os campos são obrigatórios!");
  } else {

    document.getElementById("div_resultado").innerHTML = "<br><img src='../img/spinner.gif' /> Enviando formulário...<br>";

    var http = new Ajax();
    http.open("POST", "index.php?pagina=Confirmacao.Envia", true);
    http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    http.onreadystatechange = function () {

      if (http.readyState == 4) {
        resultado = http.responseText;
        if (resultado == "ok") {
          document.getElementById("div_resultado").innerHTML = "";
          alert("Sua confirmação de pagamento foi enviada com sucesso!");
          data_pagamento = document.getElementById("data_pagamento").value = "";
          valor_pago = document.getElementById("valor_pago").value = "";
          info = document.getElementById("info").value = "";
        } else {
          document.getElementById("div_resultado").innerHTML = "<br><img src='../img/icone/icon_warning_sm.gif' /> Erro ao enviar mensagem.<br>";
          alert("Não foi possível enviar sua confirmação de pagamento! Por favor tente novamente ou entre em contato diretamente com o suporte.");
          data_pagamento = document.getElementById("data_pagamento").value = "";
          valor_pago = document.getElementById("valor_pago").value = "";
          info = document.getElementById("info").value = "";
        }
      }

    }
    http.send("codigo_fatura=" + codigo_fatura + "&data_pagamento=" + data_pagamento + "&valor_pago=" + valor_pago + "&info=" + info);
    delete http;
  }
}

// Função para enviar mensagem de troca de DNS na central do cliente
function contato_dns() {

  var dominio = document.getElementById("dominio").value;
  var mensagem = document.getElementById("mensagem").value;

  if (!mensagem) {
    alert("Por favor informe os novos DNS.");
  } else {
    document.getElementById("div_resultado").innerHTML = "<br><img src='../img/spinner.gif' /> Enviando formulário...<br>";

    var http = new Ajax();
    http.open("POST", "index.php?pagina=Contato.DNS.Envia", true);
    http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    http.onreadystatechange = function () {

      if (http.readyState == 4) {
        resultado = http.responseText;
        if (resultado == "ok") {
          document.getElementById("div_resultado").innerHTML = "";
          alert("Sua mensagem foi enviada com sucesso!");
          document.getElementById("mensagem").value = "";
        } else {
          document.getElementById("div_resultado").innerHTML = "<br><img src='../img/icone/icon_warning_sm.gif' /> Erro ao enviar mensagem.<br>";
          alert("Não foi possível enviar sua mensagem! Por favor tente novamente ou entre em contato diretamente com o suporte.");
          document.getElementById("mensagem").value = "";
        }
      }

    }
    http.send("dominio=" + dominio + "&mensagem=" + mensagem);
    delete http;
  }
}
// Função para enviar mensagem de contato do cliente pela central do cliente
function contato_central_cliente() {

  var nome = document.getElementById("nome").value;
  var email = document.getElementById("email").value;
  var assunto = document.getElementById("assunto").value;
  var mensagem = document.getElementById("mensagem").value;

  if (!nome || !email || !assunto || !mensagem) {
    alert("Todos os campos são obrigatórios!");
  } else {

    document.getElementById("div_resultado").innerHTML = "<br><img src='../img/spinner.gif' /> Enviando formulário...<br>";

    var http = new Ajax();
    http.open("POST", "index.php?pagina=Contato.Envia", true);
    http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    http.onreadystatechange = function () {

      if (http.readyState == 4) {
        resultado = http.responseText;
        if (resultado == "ok") {
          document.getElementById("div_resultado").innerHTML = "";
          alert("Sua mensagem foi enviada com sucesso!");
          document.getElementById("assunto").value = "";
          document.getElementById("mensagem").value = "";
        } else {
          document.getElementById("div_resultado").innerHTML = "<br><img src='../img/icone/icon_warning_sm.gif' /> Erro ao enviar mensagem.<br>";
          alert("Não foi possível enviar sua mensagem! Por favor tente novamente ou entre em contato diretamente com o suporte.");
          document.getElementById("assunto").value = "";
          document.getElementById("mensagem").value = "";
        }
      }

    }
    http.send("nome=" + nome + "&email=" + email + "&assunto=" + assunto + "&mensagem=" + mensagem);
    delete http;
  }
}
// Função para bloquear Ip da assinatura
function bloquear_ip(ip) {

  document.getElementById('div_status').innerHTML = "&nbsp;<img src='img/spinner.gif' />";

  var http = new Ajax();
  http.open("GET", "inc/funcoes.php?acao=bloquear_ip&ip=" + ip, true);
  http.onreadystatechange = function () {

    if (http.readyState == 4) {
      resultado = http.responseText;
      if (resultado == "ok") {
        alert("IP " + ip + " bloqueado com sucesso!");
        document.getElementById('div_status').innerHTML = "";
      } else if (resultado == "ok1") {
        alert("Erro: O IP " + ip + " já esta bloqueado!");
        document.getElementById('div_status').innerHTML = "";
      } else {
        alert("Erro: Não foi possível bloquear este IP.\nVocê pode fazer manualmente em Configurações - Empresa na aba assinatura.");
        document.getElementById('div_status').innerHTML = "";
      }
    }

  }
  http.send(null);
  delete http;
}

// Função para exibir logs do sistema
function exibir_log_sistema(codigo) {

  document.getElementById('Log_Sistema').style.display = "block";
  document.getElementById('div_janela_log').innerHTML = "<img src='img/ajax-loader.gif' align='center' />";

  var http = new Ajax();
  http.open("GET", "inc/funcoes.php?acao=exibir_log_sistema&codigo=" + codigo, true);
  http.onreadystatechange = function () {

    if (http.readyState == 4) {
      resultado = http.responseText;
      if (resultado) {
        document.getElementById('div_janela_log').innerHTML = resultado;
      } else {
        document.getElementById('div_janela_log').innerHTML = "Log do sistema não encontrado!";
      }
    }

  }
  http.send(null);
  delete http;
}

// Função para remover campos adicionais do domínio
function remover_campo_adicional(codigo) {

  document.getElementById('status_campos_adicionais').innerHTML = "&nbsp;<img src='img/spinner.gif' />";

  var http = new Ajax();
  http.open("GET", "inc/funcoes.php?acao=remover_campo_adicional&codigo=" + codigo, true);
  http.onreadystatechange = function () {

    if (http.readyState == 4) {
      resultado = http.responseText;
      if (resultado) {
        document.getElementById('status_campos_adicionais').innerHTML = "";
        document.getElementById("tabela_campos_adicionais").removeChild(document.getElementById(codigo));
      } else {
        document.getElementById('status_campos_adicionais').innerHTML = "";
        alert("Não foi possível remover este campo adicional. Tente novamente ou entre em contato com o suporte.");
      }
    }

  }
  http.send(null);
  delete http;
}

// Rotina AJAX
function Ajax() {
  var req;

  try {
    req = new ActiveXObject("Microsoft.XMLHTTP");
  } catch (e) {
    try {
      req = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (ex) {
      try {
        req = new XMLHttpRequest();
      } catch (exc) {
        alert("Esse browser não tem recursos para uso do Ajax");
        req = null;
      }
    }
  }

  return req;
}
